/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.common.config;

import com.lazrproductions.lazrslib.LazrsLibMod;
import com.lazrproductions.lazrslib.common.config.ConfigCategory;
import com.lazrproductions.lazrslib.common.config.ConfigProperty;
import com.lazrproductions.lazrslib.common.config.CreatePropertiesFunction;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public abstract class LazrConfig {
    final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    ForgeConfigSpec spec;
    final String name;
    final ModConfig.Type type;
    final ArrayList<ConfigProperty<?>> genericProperties = new ArrayList(0);
    final ArrayList<ConfigCategory> categories = new ArrayList(0);

    public LazrConfig(String name, ModConfig.Type type) {
        this.name = name;
        this.type = type;
        this.registerProperties();
    }

    public abstract void registerProperties();

    public <T> ConfigProperty<T> createGenericProperty(@Nonnull ConfigProperty<T> property) {
        this.genericProperties.add(property);
        return property;
    }

    public ConfigCategory createCategory(@Nonnull ConfigCategory category, CreatePropertiesFunction createProperties) {
        createProperties.call(category);
        this.categories.add(category);
        return category;
    }

    ForgeConfigSpec buildConfig() {
        this.builder.push(this.name + " Config");
        this.buildGenericProperties();
        this.buildCategories();
        this.builder.pop();
        LazrsLibMod.LOGGER.info("Built config '" + this.name + "' Successfully!");
        return this.builder.build();
    }

    void buildGenericProperties() {
        for (ConfigProperty<?> configProperty : this.genericProperties) {
            configProperty.build();
        }
    }

    void buildCategories() {
        for (ConfigCategory configCategory : this.categories) {
            configCategory.build();
        }
    }

    ModConfig.Type getType() {
        return this.type;
    }

    String getConfigName() {
        String typeString = "-client.toml";
        switch (this.getType()) {
            case SERVER: {
                typeString = "-server.toml";
                break;
            }
            case COMMON: {
                typeString = "-common.toml";
                break;
            }
            default: {
                typeString = "-client.toml";
            }
        }
        return this.name + typeString;
    }

    public void registerConfig(@Nonnull ModLoadingContext ctx) {
        ctx.registerConfig(this.getType(), (IConfigSpec)this.buildConfig(), this.getConfigName());
    }
}

